from pylab import *
import csv, os, Gnuplot, Gnuplot.funcutils

g = Gnuplot.Gnuplot(debug=1)

NMI = 1852.0
D2R = pi/180.0

#data = sys.argv[1]
#title = sys.argv[2]

def read_csv_file(filename):
    data = []
    for row in csv.reader(open(filename)):
        data.append(row)
    return data

def process_gps_data(data):
    latitude    = []
    longitude   = []
    intensity   = []
    gsr         = []
    for row in data:
        latitude.append(float(row[0][0:2]) + \
                            float(row[0][2:])/60.0)
        longitude.append((float(row[1][0:3]) + \
                              float(row[1][3:])/60.0))
        intensity.append(float(row[2]))
#        gsr.append(float(row[3]))

#    return (array(latitude), array(longitude), \
#                array(intensity), array(gsr))

    return (array(latitude), array(longitude), \
                array(intensity))


y=read_csv_file('/root/projects/summit/logfiles/satshortgps')
#(lat, long, intensity, gsr) = process_gps_data(y)
(lat, long, intensity) = process_gps_data(y)
# translate spherical coordinates to Cartesian
py = (lat-min(lat))*NMI*60.0
px = (long-min(long))*NMI*60.0*cos(D2R*lat)
newgsr=((gsr-min(gsr))*10.0)+500
#pack px, py, intensity and gsr into newy
newy=[]
for x,yz,z,zz in zip(px,py,intensity,newgsr):
    newy.append((x,yz,z,zz))

g('set parametric')
g('set style data line')
g('set surface')
g('unset key')
g('unset contour')
g('set dgrid3d 40,40,10')
g('set xlabel "metres EW"') 
g('set ylabel "metres SN"') 
g('set label "signal intensity"at -100,0,1000') 
g('set view 60,20')
g.title("underwater friday 6th")
g('set term png size 1200,800')
g('set output "/root/projects/summit/logfiles/images/river.png"')

#g.splot(Gnuplot.Data(newy, using=(1,2,3), with='lines'),Gnuplot.Data(newy, using=(1,2,4), with='lines'))
g.splot(Gnuplot.Data(newy, using=(1,2,3), with='lines'))
