#!/usr/bin/python

import Gnuplot, Gnuplot.funcutils, math, sys
g = Gnuplot.Gnuplot(debug=1)

# read in random number file 200 bits at time
# calculate deviation for say each 200*8 bits from say 100 1s
# accumulate deviation to be plotted
# plot also with p=0.05 distribution


def calc_limit_high_005(range):
        var = (1.96 / 2) * math.sqrt(range)
        limit_high = range/2 + var
        return limit_high

def unpack_byte(data):
    byte = []
    for x in range(8):
        byte.append((ord(data)>>x)& 0x01)
    return byte

def read_rng_data(file):
    data = []
    bytes_read = open(file, "rb").read()
    for b in bytes_read:
        data.append(unpack_byte(b))
    return data

def cum_dev(data):
    cum = []
    dev = []
    cummd=0
    for y in range(len(data)/200):
        cumd=0 
        cumz=0
        for x in range(200):
            a=data[x+(y*200)]
            if (a==0): 
                cumd+=1
            else:
                cumz+=1
        cummd+=cumz-100 # mean is 100
#        print cumd-cumz
        cum.append(cummd) 
    return cum

file=sys.argv[1]
l=(read_rng_data(file))
flatty = [item for sublist in l for item in sublist] # flattened array 
cumdevv=cum_dev(flatty)
# calculate z-score

cumdev=[]
cumd=0
for x in range(len(flatty)/200):
    cumd = (calc_limit_high_005(x*200)-x*100) # 200*100=20000
    cumdev.append(cumd)

# file name
g.title("rendlesham cumulative RNG deviation and p=0.05")
#g('set term png size 14043,9933') # A0
g('set term png size 1024,768') # example
g('set output "/root/collect2011/psych/summit2011/logimages/rendleshamRNG.png"')

g.plot(Gnuplot.Data(cumdev, with='lines'),Gnuplot.Data(cumdevv, with='lines'))

